# 💎 Diamond's Form Builder
*Making forms easy and simple to create.*

A flexible and powerful UI system for Minecraft Bedrock scripting.  
Diamond's Form Builder makes it easy to build dynamic, responsive, and modular forms using modal, message, and action types — all with a focus on clarity, reusability, and runtime logic injection.

---

## ✨ Features

- ✅ Supports Action, Modal, and Message Forms
- ✅ 20+ Modular Action Types (teleport, effects, scoreboard, sound, etc.)
- ✅ Dynamic placeholder injection using `{#KEY}` format
- ✅ Confirm/cancel chains with form memory
- ✅ Full DEBUG toggle system for development logging
- ✅ Clean file separation for advanced usage and scalability
- ✅ Mob list, vanilla constants, and colour/formatting support included
- ✅ Easy to expand and modify — made *for* the community

---

## 📁 Folder Overview

```
📆 DiamondFormBuilder/
┗📂 engine/          → Core logic and action runners
┗📂 forms/           → Form templates: modal.js, form.js
┗📂 utils/           → Injection and parser tools
┗📂 vanilla/         → Colour, effect, mob list constants
┗📂 config/          → Configurable DEBUG flag
┗📂 class/           → Holds classes that helps make certain features work
┗📂 def/             → Type Definitions (TypeScript support)
┗📅 index.js         → Script entry point
┗📅 README.md        → This file
┗📅 modalForms.md    → In-depth documentation
```

---

## 📜 Example

Here’s what a modal form looks like:

```js
{
  type: "modal",
  title: "Apply Tag",
  elements: [
    { type: "player", label: "Target Player", value: "selector" },
    { type: "textField", label: "Tag Name", value: "tag" },
    {
      type: "submitButton",
      label: "Apply",
      onSubmit: [
        {
          type: "add_tag",
          value: {
            selector: "selector",
            tag: "tag"
          }
        }
      ]
    }
  ]
}
```

You can even use placeholders dynamically in messages or values like:
```json
{ "body": "Do you want to give {#SELECTOR} the VIP tag?" }
```

---

## 🧐 Usage & Requirements

This system is designed for **Bedrock Edition script developers**.

- Works with Minecraft 1.21.90+ supporting Server UI v2.0.0+
- Requires a script-enabled behaviour pack
- Basic scripting knowledge recommended

> ⚠️ If you don’t know how to install behaviour packs or script modules, this tool may not be for you.

---

## 🔓 Licence & Usage

You are free to:
- ✅ Use it in your own projects
- ✅ Modify it to fit your needs
- ✅ Credit yourself for what *you* create

But:
- ❌ Do not re-upload the original code or claim it as your own
- ❌ Do not remove attribution without permission

> Attribution is appreciated but not required for internal use.

---

## 🙏 Credits

- Developed by **TheDiamondBlue1**  
- Released under **The Diamond Production / TDP Studio**
- Inspired by the excellent structure of **AxisCube’s EasyForm**

---

## 📬 Support / Contact

You can reach out via:
- [Our Site](http://diamondproduction.net)


---

## ⟳ Version

**Current Version:** `v1.0.0`

✅ Stable and feature-complete  
🧪 Ready for expansion (conditionals, timers, events, etc.)

---

## 💎 Make something powerful.

> *"Don't just script a form. Build an experience."*
